;;
;;  test/demos/asm/get_sp.asm
;;	Copyright (C) 2008 Markus Broeker
;;

%include "asm/tools.inc"

segment .data
label1  	db  			"NASM Powered...", 10, 0
reg_format	db				"EAX=%08x EBX=%08x ECX=%08x EDX=%08x", 10, 0
st_format	db				"EBP=%08x ESP=%08x ESI=%08x EDI=%08x", 10, 10, 0
trace_fmt	db				"[EBP-20] = %08x", 10, \
							"[EBP-16] = %08x", 10, "[EBP-12] = %08x", 10, \
							"[EBP- 8] = %08x", 10, "[EBP- 4] = %08x", 10, \
							"[EBP+ 0] = %08x", 10, "[EBP+ 4] = %08x", 10, \
							"[EBP+ 8] = %08x", 10, "[EBP+12] = %08x", 10, \
							"[EBP+16] = %08x", 10, "[EBP+20] = %08x", 10, 10, 0

segment .bss
	savexp resd 1			;; uninitialized dword value
							;; currently not used

segment .text
	global get_sp

get_sp:
	enter 4,0				;; push ebp		;; Save Base-Pointer
							;; mov ebp, esp ;; Copy Stackpointer for !!local usage!!
							;; sub esp, 4   ;; Make room for 1 DWORD

	mov [ebp-4], esp		;; Store result in !! local variable !!

	push DWORD label1
	call printf
	add esp, byte 4			;; remove label1 from stack

	call stack_trace

	call reg_info
	call stack_info

	call reg_info
	call stack_info

	call stack_trace

	;; clean up
	mov eax, [ebp-4]		;; return local var
	leave 					;; mov esp, ebp pop ebp
	ret						;; return eax
