/**
 * lsflib/src/md5sum.c
 * Copyright (C) 2008 Markus Broeker
 */

#include <stdio.h>
#include <string.h>
#include <openssl/evp.h>

#include <lsf.h>

unsigned char *md5sum (char *fname)
{
    EVP_MD_CTX mdctx;
    const EVP_MD *md;
    char line[81];
    unsigned char md_value[EVP_MAX_MD_SIZE];
    int md_len, i;
    FILE *f;
    static unsigned char *value = NULL;

    OpenSSL_add_all_digests ();

    if ((f = fopen (fname, "rb")) == NULL) {
        perror ("FOPEN");
        value = malloc (1);
        value = 0;
        return value;
    }

    if ((md = EVP_get_digestbyname ("md5")) == NULL) {
        value = malloc (1);
        value = 0;
        return value;
    }

    EVP_MD_CTX_init (&mdctx);
    EVP_DigestInit_ex (&mdctx, md, NULL);

    *line = 0;
    while ((i = fread (line, 1, 80, f)) != 0) {
        EVP_DigestUpdate (&mdctx, line, i);
    }

    fclose (f);

    EVP_DigestFinal_ex (&mdctx, md_value, (unsigned int *)&md_len);
    EVP_MD_CTX_cleanup (&mdctx);

    value = malloc (md_len + 1);

    for (i = 0; i < md_len; i++)
        value[i] = md_value[i];
    value[i] = 0;
    return value;
}
