<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\mvc\controller;

use bfw\core\Controller;
use bfw\Dispatcher;
use bfw\entities\TGroup;

/**
 * Class BenutzerverwaltungsController
 */
class BenutzerverwaltungController extends Controller {

    /**
     * BenutzerverwaltungsController constructor.
     *
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     *
     */
    public function meinProfil() {
        $request = $this->getRequest();

        $model = $this->getModel();
        if ($request->hasPost()) {
            $input = array(
                "username" => $request->session('username', ''),
                'password' => md5($request->session('password', '')),
                'firstname' => $request->session('firstname', ''),
                'lastname' => $request->session('lastname', ''),
            );

            $user = $model->getUser();
            $user->find($request->getKey('user_id'));

            $user->merge($input);
            if (!$user->store()) {
                $request->setKey('error', 'Fehler beim Aktualisieren des Benutzers.');
            } else {
                $request->setKey('msg', 'Die Daten wurden aktualisiert.');
            }
        }

        $view = $this->getView();
        $view->display();
    }

    /**
     *
     */
    public function abmelden() {
        $request = $this->getRequest();

        $request->destroySession();
        $request->initSession();

        Dispatcher::route('/');
    }

    /**
     *
     */
    public function anmelden() {
        $request = $this->getRequest();
        $view = $this->getView();

        $this->getView()->display();

        if (!$request->hasPost()) {
            // nothing to do!
            return;
        }

        $model = $this->getModel()->getUser();

        $username = $request->post('username');
        $password = $request->post('password');

        $lastpage = $request->getKey('lastpage');

        $model->findByUsername($username);

        if ($model->getPassword() == md5($password)) {
            $request->setKey('user_id', $model->getId());
            $request->setKey('group_id', $model->getGroupId());

            $request->setKey('isLoggedIn', true);

            Dispatcher::route(sprintf('/%s/', $lastpage));
        }
    }

    /**
     *
     */
    public function registrieren() {
        $request = $this->getRequest();
        $view = $this->getView();

        $model = $this->getModel();

        $view->assign('currentUser', $model->getUser());

        $this->getView()->display();
    }

    public function index() {
        $request = $this->getRequest();
        $view = $this->getView();

        $model = $this->getModel();

        $group_id = $request->getKey('group_id');

        /**
         * Hier muss eine ACL-Schicht dazu
         *
         */
        if ($group_id != TGroup::ADMIN) {
            Dispatcher::route('/');
        }

        $users = $model->getUsers();
        $groups = $model->getGroups();

        $view->assign('users', $users);
        $view->assign('groups', $groups);

        $this->getView()->display();
    }

}
