<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\entities;

use bfw\core\Entity;

/**
 * Class TView
 *
 * @method string getId()
 */
class TView extends Entity {

    /**
     * Nur Get-Methoden im View
     *
     * @param $methodName
     * @param null $params
     * @return mixed
     */
    public function __call($methodName, $params = null) {
        $prefix = substr($methodName, 0, 3);
        $key = strtolower(substr($methodName, 3));

        if ($prefix == 'get') {
            if (array_key_exists($key, $this->data)) {
                return $this->data[$key];
            }
        }

        exit(sprintf('Unbekannte Methode %s(%s, %s) wurde aufgerufen.', $methodName, $key, $prefix));
    }

    /**
     * @return bool
     */
    public function store() {
        return false;
    }

    /**
     * @return bool
     */
    public function delete() {
        return false;
    }

    /**
     * @return bool
     */
    public function persist() {
        return false;
    }
}