<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\database;

interface DBInterface {

    /* fetch methods */
    public function fetch($table, $cond);

    public function fetchAll($table, $cond);

    /* find methoden */
    public function find($table, $id);

    public function findAll($table, $initial_id);

    public function findByField($table, $field, $value);

    function findAllByField($table, $field, $value);

    /* Abfrage Methoden */
    public function query($sql);

    /* Persistence Methods */
    public function persist($table, $array);

    public function store($table, $id, $array);

    public function delete($table, $id);

    /* PK Management */
    public function getLastInsertedId();
}