<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\core;

use bfw\entities\TGroup;
use bfw\entities\TUser;
use Logger;

/**
 * Class Model
 *
 */
class Model {
    protected $logger;

    /**
     * @var TUser
     */
    private $user;

    /**
     * @var TGroup
     */
    private $group;

    public function __construct() {
        $this->logger = Logger::getLogger(get_class($this));

        $this->user = new TUser();
        $this->group = new TGroup();
    }


    /**
     * @return TUser
     */
    public function getUser() {
        return $this->user;
    }

    /**
     * @return TGroup
     */
    public function getGroup() {
        return $this->group;
    }

    /**
     * @return Entity[]
     */
    public function getUsers() {
        return $this->user->findAll();
    }

    /**
     * @return Entity[]
     */
    public function getGroups() {
        return $this->group->findAll();
    }
}