<h2 class="text-center">Ticketverwaltung</h2>
<hr/>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            {include file="tickets/ticketanlegen.tpl"}
        </div>

        <br class="clearfix"/>
    </div>
</div>

{if $tickets != null}
    <br class="clearfix"/>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <table class="achtel">
                    <tr>
                        <th>Nummer</th>
                        <th>Besitzer</th>
                        <th>Betreff</th>
                        <th>Nachricht</th>
                        <th>Status</th>
                        <th>Aktion1</th>
                        <th>Aktion2</th>
                        <th>Aktion3</th>
                    </tr>
                </table>
            </div>
        </div>

        <div class="row">
            {foreach $tickets as $ticket}
                <div class="col-lg-12">
                    <form action="/tickets/" method="post">
                        <table class="achtel">
                            {assign var="coloredRow" value=""}
                            {if $ticket->getLocked()}
                                {assign var="coloredRow" value="yellow-row"}
                            {/if}

                            {if $ticket->getStatus_Id() == $tStatus::GESCHLOSSEN}
                                {assign var="coloredRow" value="red-row"}
                            {/if}

                            <tr class="{$coloredRow}">
                                <td><input readonly='readonly' type="text" name="tid" value="{$ticket->getId()}"/></td>
                                <td><input readonly='readonly' type="text" name="username" value="{$tUser->getFormattedUsername($ticket->getUser_Id())}"/></td>
                                <td><input readonly='readonly' type="text" name="subject" value="{$ticket->getSubject()}"/></td>
                                <td><input readonly='readonly' type="text" name="message" value="{strip_tags(html_entity_decode($ticket->getMessage()))}"/></td>
                                <td><input readonly='readonly' type="text" name="status" value="{$tStatus->getFormattedStatus($ticket->getStatus_Id())}"/></td>

                                {if $group_id != $tGroup::GUEST}
                                    {if $group_id == $tGroup::SUPPORTER && $ticket->getLocked() == 0}
                                        <td><input type="submit" name="laden" value="annehmen"/></td>
                                    {else}
                                        <td><input type="submit" name="laden" value="laden"/></td>
                                    {/if}
                                {else}
                                    <td>Bearbeiten ist gesperrt</td>
                                {/if}

                                {if $group_id == $tGroup::MANAGER || $group_id == $tGroup::ADMIN}
                                    <td><input type="submit" name="loeschen" value="löschen"/></td>
                                {else}
                                    <td>Löschen ist gesperrt</td>
                                {/if}
                                <td><input type="submit" name="historie" value="Historie"/></td>
                            </tr>
                        </table>
                    </form>
                </div>
            {/foreach}
        </div>
    </div>
{/if}