<?php

namespace bfw\mvc\model;

use bfw\mvc\common\Model;
use Logger;

/**
 * Class TUser
 *
 * @method string getUsername()
 * @method int getGroup_Id()
 * @method string getPassword()
 * @method string getFirstname()
 * @method string getLastname()
 * @method setUsername()
 * @method setGroup_Id()
 * @method setPassword()
 * @method setFirstname()
 * @method setLastname()
 */
class TUser extends Model {
    const SYSTEM = 1;
    private static $logger = null;

    public function __construct() {
        parent::__construct('t_user');

        self::$logger = Logger::getLogger('__CLASS__');

        $this->data = array(
            'id' => NULL,
            'group_id' => TGroup::SYSTEM,
            'username' => '',
            'firstname' => '',
            'lastname' => '',
            'password' => '',
        );
    }

    /**
     * <b>Liefert eine User-Instanz für den per Parameter übergebenen Nutzernamen.</b>
     *
     * @param $username
     * @return array|null
     */
    public function findByUsername($username) {
        $this->data = $this->db->findByField($this->table, 'username', $username);

        if ($this->data == null) {
            return null;
        }

        return $this;
    }

    /**
     * <b>Liefert den formatierten Nutzernamen zur übergebenen Nutzer-Id</b>
     *
     * @param $user_id
     * @return string
     */
    public function getFormattedUsername($user_id) {
        $user = $this->find($user_id);

        if (!is_object($user)) {
            return 'Unbekannt, Unbekannt';
        }

        return sprintf("%s, %s", $user->getLastname(), $user->getFirstname());
    }

    /**
     * <b>FindMethode für alle Manager und Darunter</b>
     *
     * @return array|null
     */
    public function findAllManagersAndBelow() {
        $managers = $this->db->query(sprintf("
            SELECT
                *
            FROM
              `%s`
            WHERE
              `group_id` in (3,4,5)",
            $this->table));

        $list = array();
        foreach ($managers as $manager) {
            $item = new static();
            $item->data = $manager;

            $list[] = $item;
        }

        return $list;
    }

    /**
     * liefert den PK des nächst freien Supporters oder
     * im Falle von nicht vorhandenen Supportern den System-Datensatz
     *
     * @return int
     */
    public function getFreeSupporterId() {

        $sql = sprintf("
          SELECT
	        u.id,
	        COUNT(t.user_id) AS `count`
          FROM
	        t_user u
	      LEFT JOIN
	          t_ticket t ON u.id = t.user_id
          WHERE
                u.group_id = 4
          GROUP BY
            u.id
          ORDER BY
            `count` ASC
        ");

        $data = $this->db->query($sql);

        if ($data == null) {
            // Ich will hier definitiv immer eine gültige ID haben, also einen PK
            return 1;
        }

        self::$logger->info(sprintf("Data: %s", print_r($data, true)));

        return $data[0]['id'];
    }

    /**
     * <b>Anzahl der Tickets eines Benutzers</b>
     *
     * @return mixed
     */
    public function getTicketCount() {
        $sql = sprintf("
            SELECT
              count(*) as anzahl
            FROM
                t_ticket
            WHERE
                user_id = %d
        ", $this->getId());

        $data = $this->db->query($sql);

        return $data[0]['anzahl'];
    }

}