<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw;

/**
 * Class Response
 */
class Response {

    /**
     *
     * @var array
     */
    private $headers;

    /**
     *
     * @var int
     */
    private $statusCode;

    /**
     *
     */
    public function __construct() {
        $this->headers = headers_list();
        $this->statusCode = http_response_code();
    }

    /**
     *
     * @return array
     */
    public function getHeaders() {
        return $this->headers;
    }

    /**
     *
     * @return int
     */
    public function getStatusCode() {
        return $this->statusCode;
    }

    /**
     *
     * @param int $statusCode
     *
     * @return \bfw\Response
     */
    public function setStatusCode($statusCode) {
        $this->statusCode = $statusCode;

        return $this;
    }

    /**
     * @param $key
     *
     * @return string
     */
    public function get($key) {
        if (array_key_exists($key, $this->headers)) {
            return $this->headers[$key];
        }

        return '';
    }

}
