<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw;

use PDO;

class Configuration {

    /**
     * Standard-Autoloader für die Basis-Klassen des Projekts
     *
     * @param $class
     * @return bool
     */
    public static function bfw_autoLoader($class) {
        $nsClass = str_replace('\\', '/', $class);
        $filename = sprintf('%s/classes/%s.php', BFW_PATH, $nsClass);
        $classPath = sprintf('classes/%s.php', $nsClass);

        if (file_exists($filename)) {
            require_once BFW_PATH . "/$classPath";

            return true;
        }

        return false;
    }

    /**
     * Standard Konfiguration für den Logger
     *
     * @return array
     */
    public static function bfw_loggerConfiguration() {
        return array(
            'rootLogger' => array('appenders' => array('default')),
            'appenders' => array(
                'default' => array(
                    'class' => 'LoggerAppenderFile',
                    'layout' => array('class' => 'LoggerLayoutSimple'),
                    'params' => array(
                        'file' => BFW_PATH . '/logs/bfw.log',
                        'append' => true
                    )
                )
            )
        );
    }

    /**
     * Standard Konfiguration für den PDO-Treiber
     *
     * @return array
     */
    public static function getDataSourceProperties() {
        $dataSources = array(
            'psql' => array(
                'dsn' => 'pgsql:host=localhost;dbname=bfw',
                'config' => array(),
                'username' => 'bfw',
                'password' => 'bfw',
            ),

            'mysql' => array(
                'dsn' => 'mysql:host=localhost;dbname=bfw',
                'config' => array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'),
                'username' => 'bfw',
                'password' => 'bfw',
            )
        );

        return $dataSources['mysql'];
    }
}
