<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\mvc\model\benutzerverwaltung;

use bfw\core\Entity;
use bfw\entities\TGroup;
use bfw\entities\TUser;

class Model extends \bfw\core\Model {

    /**
     * @var TUser
     */
    private $user;

    /**
     * @var TGroup
     */
    private $group;

    public function __construct() {
        $this->user = new TUser();
        $this->group = new TGroup();
    }

    /**
     * @return TUser
     */
    public function getUser() {
        return $this->user;
    }

    /**
     * @return TGroup
     */
    public function getGroup() {
        return $this->group;
    }

    /**
     * @return Entity[]
     */
    public function getUsers() {
        return $this->user->findAll();
    }

    /**
     * @return Entity[]
     */
    public function getGroups() {
        return $this->group->findAll();
    }

}