<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw;

use bfw\core\Controller;
use ReflectionClass;
use ReflectionException;

class Dispatcher {
    private $request;

    public function __construct() {
        $this->request = new Request();
    }

    /**
     * @param $url
     */
    public static function route($url) {
        header(sprintf("Location: %s", $url));
        exit(0);
    }

    /**
     * <b>Standard Request Handler für das Projekt</b>
     *
     * Diese Instanz kümmert sich selbständig um die GET- und POST Werte und
     * speichert diese in der Session.
     *
     * Einfach zu nutzende Methoden(Schnittstelle zur Session) komplettieren diesen Handler
     *
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * <b>Führt den jeweiligen Controller aus</b>
     *
     */
    public function delegate() {
        $this->request->keepRequestData();

        $controllerName = $this->request->get('controller', 'home');
        $action = $this->request->get('action', 'index');

        $class = Controller::findControllerInNameSpace($controllerName);

        try {
            $reflection = new ReflectionClass($class);
            $controller = $reflection->newInstance();

            // Mapping vom GET-Parameter 'action' auf Controller::$action()
            if (!$reflection->hasMethod($action)) {
                $action = 'index';
            }
        } catch (ReflectionException $re) {
            $controller = new mvc\controller\ErrorController();
            $action = 'index';
        }

        return $controller->$action();
    }

}