<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\core;

use bfw\Request;
use bfw\Response;
use Logger;

/**
 *
 */
abstract class Controller {
    protected $logger;
    /**
     * @var Model
     */
    private $model;
    /**
     * @var Request
     */
    private $request;
    /**
     * @var Response
     */
    private $response;
    /**
     * @var View
     */
    private $view;

    /**
     * Controller constructor.
     *
     * @param Model $model
     */
    public function __construct(Model $model) {
        $this->request = new Request();
        $this->response = new Response();

        $this->model = $model;
        $this->view = new View($this, $model);

        $this->logger = Logger::getLogger(get_class($this));
    }

    /**
     * @param $controller
     * @return string
     */
    public static function mapControllerName($controller) {
        return sprintf('bfw\mvc\controller\%sController', ucfirst($controller));
    }

    /**
     * @return View
     */
    public function getView() {
        return $this->view;
    }

    /**
     * @param $view
     * @return $this
     */
    public function setView($view) {
        $this->view = $view;

        return $this;
    }

    /**
     * @return Response
     */
    public function getResponse() {
        return $this->response;
    }

    /**
     * @param $response
     * @return $this
     */
    public function setResponse($response) {
        $this->response = $response;

        return $this;
    }

    /**
     * @return Model
     */
    public function getModel() {
        return $this->model;
    }

    /**
     * @param $model
     * @return $this
     */
    public function setModel($model) {
        $this->model = $model;

        return $this;
    }

    /**
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * @return mixed
     */
    abstract public function index();

    public function getDataModelInstance() {
        $modelName = $this->getModelName();

        return new $modelName();
    }

    private function getModelName() {
        $modelName = str_replace('controller', 'model', get_class($this));
        $modelName = strtolower($modelName);

        return str_replace('controller', '\DataModel', $modelName);
    }
}