<?php

header('Content-Type: text/plain');

$cfg = array(
    'dsn' => 'mysql:host=localhost;',
    'config' => array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'),
    'username' => 'root',
    'password' => '',
);

require_once '../config/config.php';

use bfw\database\Database;

$db = Database::getInstance($cfg);

$dropSQLStatements = array(
    "DROP USER 'bfw'@'localhost'",
    "DROP DATABASE IF EXISTS bfw;",
);

$createSQLStatements = array(
    "CREATE DATABASE bfw CHARACTER SET utf8 COLLATE utf8_unicode_ci;",
    "CREATE USER 'bfw'@'localhost' IDENTIFIED BY 'bfw';",
    "GRANT ALL PRIVILEGES ON bfw.* TO 'bfw'@'localhost' WITH GRANT OPTION;",
);

foreach ($dropSQLStatements as $statement) {
    $status = $db->execute($statement);
    echo sprintf("%s\n", $statement);
}

foreach ($createSQLStatements as $statement) {
    $status = $db->execute($statement);
    echo sprintf("%s\n", $statement);
}

$handle = fopen(BFW_PATH . '/sql/init.sql', 'r');

$sql = "USE bfw;\n\n";
while (!feof($handle)) {
    $sql .= fgets($handle);
}

fclose($handle);

if ($db->execute($sql) == 0) {
    echo sprintf("%s", $sql);

    header('Location: /');
}
