<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\entities;

/**
 * 
 */
class TUser extends \bfw\entities\core\TUser {

    const SYSTEM = 1;

    /**
     * <b>Liefert eine User-Instanz für den per Parameter übergebenen Nutzernamen.</b>
     *
     * @param $username
     * @return array|null
     */
    public function findByUsername($username) {
        $this->data = $this->db->findByField($this->table, 'username', $username);

        if ($this->data == null) {
            return null;
        }

        return $this;
    }

    /**
     * <b>Liefert den formatierten Nutzernamen zur übergebenen Nutzer-Id</b>
     *
     * @param $user_id
     * @return string
     */
    public function getFormattedUsername($user_id) {
        $user = $this->find($user_id);

        if (!is_object($user)) {
            return null;
        }

        return sprintf("%s, %s", $user->getLastname(), $user->getFirstname());
    }

}
