<?php

require_once '../../config/config.php';

use bfw\database\Database;

class DatabaseTest extends \PHPUnit_Framework_TestCase {
    private $object;

    public function __construct() {
        $this->object = Database::getInstance();
    }

    public function testStore() {
        $data = array();
        $data['password'] = md5(rand(0, 255));

        $result = $this->object->store('t_user', 1, $data);
        $this->assertTrue($result !== false);
    }

    public function testFetch() {
        $data = $this->object->fetch('t_user', 'id = 1');

        $this->assertEquals('system@testbox.de', $data['username']);
    }

    public function testFetchAll() {
        $data = $this->object->fetchAll('t_user', 'id < 3');

        $this->assertTrue(is_array($data));

        foreach ($data as $row) {
            echo sprintf("%s\n", implode(', ', $row));
        }
    }

    public function testFind() {
        $data = $this->object->find('t_user', -1);
        $this->assertEquals(null, $data);

        $data = $this->object->find('t_user', 1);
        $this->assertEquals(1, $data['id']);
    }

    public function testFindAll() {
        $data1 = $this->object->findAll('t_user', true);
        $data2 = $this->object->findAll('t_user', false);

        $this->assertTrue(count($data1) != count($data2));
    }
}
