<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\mvc\controller;

use bfw\core\Controller;
use bfw\Dispatcher;

class BenutzerverwaltungController extends Controller {

    /**
     * BenutzerverwaltungsController constructor.
     *
     */
    public function __construct() {
        $model = $this->getDataModelInstance();
        parent::__construct($model);
    }

    /**
     *
     */
    public function meinProfil() {
        $request = $this->getRequest();
        $view = $this->getView();
    }

    /**
     *
     */
    public function abmelden() {
        $request = $this->getRequest();
        $view = $this->getView();

        $request->destroySession();
        $request->initSession();
    }

    /**
     *
     */
    public function anmelden() {
        $request = $this->getRequest();
        $view = $this->getView();

        if (!$request->hasPost()) {
            // nothing to do!
            return;
        }

        $model = $this->getModel()->getUser();

        $username = $request->post('username');
        $password = $request->post('password');

        $lastpage = $request->getKey('lastpage');

        $model->findByUsername($username);

        if ($model->getPassword() == md5($password)) {
            $request->setKey('user_id', $model->getId());
            $request->setKey('group_id', $model->getGroup_Id());

            $request->setKey('isLoggedIn', true);

            Dispatcher::route(sprintf('/%s/', $lastpage));
        }
    }

    /**
     *
     */
    public function registrieren() {
        $request = $this->getRequest();
        $view = $this->getView();

        $model = $this->getModel();

        $view->assign('currentUser', $model->getUser());
    }

    public function index() {
        $request = $this->getRequest();
        $view = $this->getView();

        $model = $this->getModel();

        $users = $model->getUsers();
        $groups = $model->getGroups();

        $view->assign('users', $users);
        $view->assign('groups', $groups);
    }
}