<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\entities;

use bfw\core\Entity;

/**
 * Class TUser
 *
 * @method string getUsername()
 * @method int getGroup_Id()
 * @method string getPassword()
 * @method string getFirstname()
 * @method string getLastname()
 * @method setUsername()
 * @method setGroup_Id()
 * @method setPassword()
 * @method setFirstname()
 * @method setLastname()
 */
class TUser extends Entity {
    const SYSTEM = 1;

    public function __construct() {
        parent::__construct('t_user');

        $this->data = array(
            'id' => NULL,
            'group_id' => TGroup::SYSTEM,
            'username' => '',
            'firstname' => '',
            'lastname' => '',
            'password' => '',
        );
    }

    /**
     * <b>Liefert eine User-Instanz für den per Parameter übergebenen Nutzernamen.</b>
     *
     * @param $username
     * @return array|null
     */
    public function findByUsername($username) {
        $this->data = $this->db->findByField($this->table, 'username', $username);

        if ($this->data == null) {
            return null;
        }

        return $this;
    }

    /**
     * <b>Liefert den formatierten Nutzernamen zur übergebenen Nutzer-Id</b>
     *
     * @param $user_id
     * @return string
     */
    public function getFormattedUsername($user_id) {
        $user = $this->find($user_id);

        if (!is_object($user)) {
            return null;
        }

        return sprintf("%s, %s", $user->getLastname(), $user->getFirstname());
    }

}