<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\core;

use bfw\entities\TGroup;
use bfw\entities\TUser;
use Smarty;

require_once 'library/smarty/libs/Smarty.class.php';

class View extends Smarty {
    /**
     * Statische Referenz auf die reale Template Engine, hier Smarty
     *
     * @var Smarty
     */
    private static $tpl = null;
    /**
     * @var Model
     */
    private $model;
    /**
     * @var Controller
     */
    private $controller;

    /**
     * View constructor.
     *
     * @param Controller $controller
     * @param Model $model
     */
    public function __construct(Controller $controller, Model $model) {
        $this->controller = $controller;
        $this->model = $model;

        self::$tpl = self::getTemplateEngine();
    }

    /**
     * <b>Liefert ein statisches Handle auf die aktuelle Template Engine zurück</b>
     *
     * Das Singleton Pattern garantiert genau eine Instanz der Template Engine im Speicher.
     *
     *  <b>Verschiedene Skripte können so nacheinander Variablen zuweisen und diese bei Bedarf auslesen</b>
     *
     * @return Smarty
     */
    private static function getTemplateEngine() {
        if (self::$tpl == null) {
            self::$tpl = new Smarty();

            $tpl = self::$tpl;

            $tpl->setCompileDir('./data/templates_c/');
            $tpl->setTemplateDir('./classes/bfw/mvc/view/');
        }

        return self::$tpl;
    }

    /**
     * weisst automatisch eine user-instanz zu: Seiten-Effekte beachten
     *
     * TODO: Namensschema festlegen, damit dieser Effekt nicht auftritt
     */
    public function display() {
        $user = new TUser();
        $group = new TGroup();

        $request = $this->controller->getRequest();

        if ($request->getKey('isLoggedIn')) {
            $user->find($request->getKey('user_id'));
        }

        $controller = $this->controller;

        $response = $controller->getResponse();
        $this->assign('response', $response);

        $this->assign('user', $user);
        $this->assign('group', $group);

        $this->assign('request', $request);

        try {
            self::$tpl->display('layout.tpl');
        } catch (SmartyException $se) {
            $response->setStatusCode(404);

            $page = 'error/error';
            self::$tpl->assign('page', $page);

            self::$tpl->display('layout.tpl');
        }

        // Msg wieder auf Null setzen...
        $request->setKey('msg', '');

        // Fehler wieder auf Null setzen...
        $request->setKey('fehler', '');
    }

    public function assign($key, $value) {
        self::$tpl->assign($key, $value);
    }

}
