<?php

namespace bfw\mvc\model {

    /**
     * Class TView
     *
     * @method string getId()
     */
    class TView extends Model {

        /**
         * Nur Get-Methoden im View
         *
         * @param $methodName
         * @param null $params
         * @return mixed
         */
        public function __call($methodName, $params = null) {
            $prefix = substr($methodName, 0, 3);
            $key = strtolower(substr($methodName, 3));

            if ($prefix == 'get') {
                if (array_key_exists($key, $this->data)) {
                    return $this->data[$key];
                }
            }

            exit(sprintf('Unbekannte Methode %s(%s, %s) wurde aufgerufen.', $methodName, $key, $prefix));
        }

        /**
         * @param $id
         * @param $object
         * @return bool
         */
        public function store($id, $object) {
            return false;
        }

        /**
         * @param $id
         * @return bool
         */
        public function delete($id) {
            return false;
        }

        /**
         * @param $id
         * @param $object
         * @return bool
         */
        public function persist($id, $object) {
            return false;
        }
    }
}