<?php

namespace bfw\mvc\controller {

    /**
     * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
     *
     */

    use bfw\mvc\model\TGroup;
    use bfw\mvc\model\TTicket;
    use bfw\mvc\model\TUser;

    class HistoryController extends Controller {

        private $user_id;
        private $group_id;
        private $currentTicket;

        public function __construct($model, $request) {
            parent::__construct($model, $request);

            $this->currentTicket = null;

            $this->user_id = $request->getKey('user_id', TUser::SYSTEM);
            $this->group_id = $request->getKey('group_id', TGroup::GUEST);
        }

        public function index() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $tid = $request->session('tid');
            $ticket = new TTicket();

            $user_id = $request->session('user_id');

            if ($ticket->find($tid, $user_id) == null) {
                $request->setKey('fehler', 'Datensatz nicht gefunden.');
                $ticket = new TTicket();
            }

            $history = $this->getModel();
            $histories = $history->findAllByField('ticket_id', $tid);
            if ($histories == null) {
                $request->setKey('fehler', 'Die Daten sind nicht aktuell.');
            }

            $engine->assign('ticket', $ticket);
            $engine->assign('histories', $histories);
        }

    }
}