<?php

namespace bfw {

    /**
     * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
     *
     */

    use bfw\mvc\controller\Controller as Controller;
    use bfw\mvc\view\View as View;

    class Dispatcher {
        private $request;

        public function __construct() {
            $this->request = new Request();
        }

        /**
         * <b>Standard Request Handler für das Projekt</b>
         *
         * Diese Instanz kümmert sich selbständig um die GET- und POST Werte und
         * speichert diese in der Session.
         *
         * Einfach zu nutzende Methoden(Schnittstelle zur Session) komplettieren diesen Handler
         *
         * @return Request
         */
        public function getRequest() {
            return $this->request;
        }

        /**
         * <b>Führt den jeweiligen Controller aus und liefert ein View zurück</b>
         *
         */
        public function getView() {
            $page = $this->request->get('page');
            $this->request->keepRequestData();

            if ($page == '') {
                $page = 'home';
            }

            try {
                $class = Controller::mapControllerName($page);
                $args = Controller::getArgsForController($class);

                $reflection = new \ReflectionClass($class);
                $controller = $reflection->newInstanceArgs($args);

                $prefix = str_replace('bfw\mvc\controller\\', '', strtolower($class));
                $controller->setPrefix(str_replace('controller', '', $prefix));

                // Mapping vom GET-Parameter 'page' auf Controller::$page()
                if ($reflection->hasMethod($page)) {
                    $controller->$page();
                } else {
                    $controller->index();
                }
            } catch (Exception $e) {
                $controller = new ErrorController(new TView('NON_EXISTENT'), $this->request);
            }

            $view = new View($controller, $controller->getModel());
            $view->assign('page', sprintf('%s/%s', $controller->getPrefix(), $page));

            return $view;
        }

        /**
         * @param $url
         */
        public static function route($url) {
            header(sprintf("Location: %s", $url));
            exit(0);
        }

    }
}