<?php

namespace bfw\mvc\controller {

    /**
     * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
     *
     */

    use bfw\mvc\model\Model;
    use bfw\mvc\model\THistory;
    use bfw\mvc\model\TTicket;
    use bfw\mvc\model\TUser;
    use bfw\mvc\view\View;
    use bfw\Request;
    use bfw\Response;

    interface ActionInterface {
        public function index();
    }

    /**
     *
     */
    abstract class Controller implements ActionInterface {
        /**
         * @var Model
         */
        private $model;

        /**
         * @var Request
         */
        private $request;

        /**
         * @var Response
         */
        private $response;

        /**
         * @var View
         */
        private $view;

        /**
         * @var
         */
        private $prefix;

        /**
         * Controller constructor.
         *
         * @param Model $model
         * @param Request $request
         */
        public function __construct(Model $model, Request $request) {
            $this->request = $request;
            $this->response = new Response();

            $this->model = $model;
            $this->view = new View($this, $model);

            $this->prefix = '';
        }

        public function getPrefix() {
            return $this->prefix;
        }

        public function setPrefix($prefix) {
            $this->prefix = $prefix;

            return $this;
        }

        public function getView() {
            return $this->view;
        }

        public function setView($view) {
            $this->view = $view;

            return $this;
        }

        public function getResponse() {
            return $this->response;
        }

        public function setResponse($response) {
            $this->response = $response;

            return $this;
        }

        /**
         * @return Model
         */
        public function getModel() {
            return $this->model;
        }

        /**
         * @param $model
         * @return $this
         */
        public function setModel($model) {
            $this->model = $model;

            return $this;
        }

        /**
         * @return Request
         */
        public function getRequest() {
            return $this->request;
        }

        /**
         * @return string
         */
        public function getPage() {
            if ($this->getPrefix() != '') {
                return sprintf('%s/%s', $this->prefix, $this->request->get('page'));
            }

            return $this->request->get('page');
        }

        /**
         * @param $page
         * @return string
         */
        public static function mapControllerName($page) {
            switch ($page) {
                case 'benutzerverwaltung':
                case 'meinprofil':
                case 'resetpasswort':
                case 'registrieren':
                case 'anmelden':
                case 'abmelden':
                    return 'bfw\mvc\controller\BenutzerverwaltungsController';
                case 'home':
                    return 'bfw\mvc\controller\HomeController';
                case 'tickets':
                case 'ticketanlegen':
                    return 'bfw\mvc\controller\TicketsController';
                case 'historie':
                    return 'bfw\mvc\controller\HistoryController';

                default:
                    return 'bfw\mvc\controller\ErrorController';
            }
        }

        public static function getArgsForController($controllerName) {
            switch ($controllerName) {
                case 'bfw\mvc\controller\BenutzerverwaltungsController':
                    $model = new TUser();

                    return array($model, new Request());
                case 'bfw\mvc\controller\HistoryController':
                    $model = new THistory();

                    return array($model, new Request());
                case 'bfw\mvc\controller\HomeController':
                    $model = new TUser();

                    return array($model, new Request());
                case 'bfw\mvc\controller\TicketsController':
                    $model = new TTicket();

                    return array($model, new Request());
                default:
                    $model = new TUser();

                    return array($model, new Request());
            }

            throw new InvalidArgumentException(sprintf('Unbekannter Controller für %s', $controllerName));
        }

    }
}