<?php

namespace bfw\mvc\controller {

    /**
     * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
     *
     */

    use bfw\Dispatcher;
    use bfw\mvc\model\Model;
    use bfw\mvc\model\TGroup;
    use bfw\mvc\model\TUser;

    class BenutzerverwaltungsController extends Controller {
        private static $logger = null;

        /**
         * BenutzerverwaltungsController constructor.
         *
         * @param Model $model
         * @param Request $request
         */
        public function __construct($model, $request) {

            parent::__construct($model, $request);
        }

        /**
         *
         */
        public function loeschenFunc() {
            $tUser = $this->getModel();
            $request = $this->getRequest();

            $uid = $request->session('uid');

            if (!$tUser->delete($uid)) {
                $request->setKey('fehler', 'Der Benutzer konnte nicht gelöscht werden.');
                Dispatcher::route('/home/');
            } else {
                $request->setKey('msg', 'Der Benutzer wurde gelöscht.');
            }
        }

        /**
         *
         */
        public function aendernFunc() {
            $request = $this->getRequest();

            $uid = $request->session('uid');
            $username = $request->session('username');
            $password = $request->session('password');
            $group_id = $request->session('groupbox');

            $tUser = $this->getModel();
            $user = $tUser->find($uid);

            $user->setUsername($username);
            if ($password != '') {
                $user->setPassword(md5($password));
            }

            if ($group_id != '') {
                $user->setGroup_id($group_id);
            }

            if ($tUser->store($user->getId(), $user)) {
                $request->setKey('msg', 'Der Benutzer wurde erfolgreich aktualisiert.');
            } else {
                $request->setKey('fehler', 'Der Benutzer konnte nicht aktualisiert werden.');
            }
        }

        /**
         *
         * @param $currentUser
         * @return mixed
         */
        public function registrierenFunc($currentUser) {
            $request = $this->getRequest();

            $password1 = $request->session('password1');
            $password2 = $request->session('password2');

            if (strlen($password1) == 0) {
                return $currentUser;
            }

            // Validierung
            if ($password1 != $password2) {
                $request->setKey('fehler', 'Die Passwörter sind verschieden.');
                return $currentUser;
            }

            $username = $request->session('username');
            $firstname = $request->session('firstname');
            $lastname = $request->session('lastname');

            $currentUser->setUsername($username);
            $currentUser->setPassword(md5($password1));
            $currentUser->setFirstname($firstname);
            $currentUser->setLastname($lastname);
            $currentUser->setGroup_Id(TGroup::SUPPORTER);

            if ($username == '' || $firstname == '' || $lastname == '') {
                $request->setKey('fehler', 'Sie müssen die Pflichtfelder ausfüllen.');
                return $currentUser;
            }

            if ($currentUser->persist($currentUser)) {
                $request->setKey('msg', 'Der Nutzer wurde angelegt.');

                if ($currentUser->findByUsername($currentUser->getUsername())) {
                    $request->setKey('isLoggedIn', true);
                    $request->setKey('user_id', $currentUser->getId());
                    $request->setKey('group_id', $currentUser->getGroup_id());

                    Dispatcher::route('/meinprofil/');
                }
            } else {
                $request->setKey('fehler', 'Der Nutzer konnte nicht angelegt werden.');
            }

            return $currentUser;
        }

        /**
         *
         * @return bool
         */
        public function resetPasswordFunc() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $username = $request->session('username');

            if (!$request->hasPost()) {
                return false;
            }

            $tUser = $this->getModel();

            if ($tUser->findByUsername($username)) {
                $tUser->setPassword(md5($tUser->getUsername()));

                return $tUser->store($tUser->getId(), $tUser);
            }

            $engine->assign('request', $request);
            return false;
        }

        /**
         *
         */
        public function meinProfil() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $username = $request->session('username');

            $tUser = $this->getModel();
            $user = $tUser->find($request->getKey('user_id'));

            if ($request->post('aendern') != '') {
                $firstname = $request->session('firstname');
                $lastname = $request->session('lastname');

                $tUser = new TUser();
                $tUser->setUsername($username);
                $tUser->setFirstname($firstname);
                $tUser->setLastname($lastname);

                $password = $request->session('password');
                if ($password != '') {
                    $tUser->setPassword(md5($password));
                }

                if ($tUser->store($user->getId(), $tUser)) {
                    $request->setKey('msg', 'Der Nutzer wurde aktualisiert.');
                    $tUser->findByField('username', $tUser->getUsername());
                } else {
                    $request->setKey('fehler', 'Der Nutzer konnte nicht aktualisiert werden.');
                }
            }
        }

        /**
         *
         */
        public function abmelden() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $request->deleteKey('username');
            $request->deleteKey('group_id');
            $request->destroySession();

            Dispatcher::route('/');
        }

        /**
         *
         */
        public function anmelden() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $username = $request->session('username');
            $password = md5($request->session('password'));

            $tUser = $this->getModel();
            $user = $tUser->findByUsername($username);

            if ($user == null) {
                return;
            }

            if (($username == $user->getUsername()) && ($password == $user->getPassword())) {
                $request->setKey('isLoggedIn', true);
                $request->setKey('user_id', $user->getId());
                $request->setKey('group_id', $user->getGroup_id());

                $tGroup = new TGroup();
                if (($group = $tGroup->find($user->getGroup_Id())) == null) {
                    $request->setKey('fehler', "DB-Inkonsistenz: Prüfen Sie die exisitierenden Gruppen.");
                }

                $msg = sprintf('Sie gehören der Gruppe %s an.', $group->getName());
                $request->setKey('msg', $msg);

                $lastpage = $request->getKey('lastpage');
                if ($lastpage == 'anmelden') {
                    $lastpage = 'tickets';
                }

                $request->setKey('lastpage', $lastpage);

                // Routing ist final
                Dispatcher::route(sprintf('/%s/', $lastpage));
            }

        }

        /**
         *
         */
        public function registrieren() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $currentUser = new TUser();
            if ($request->post('registrieren') != '') {
                $currentUser = $this->registrierenFunc($currentUser);
            }

            $engine->assign('currentUser', $currentUser);
        }

        /**
         *
         */
        public function index() {
            $request = $this->getRequest();
            $engine = $this->getView();

            $tUser = $this->getModel();
            $tGroup = new TGroup();

            if ($request->post('loeschen') != '') {
                $this->loeschenFunc();
            }

            if ($request->post('aendern') != '') {
                $this->aendernFunc();
            }

            $group_id = $request->getKey('group_id', TGroup::GUEST);

            switch ($group_id) {
                case TGroup::ADMIN:
                    $users = $tUser->findAll();
                    $groups = $tGroup->findAll();
                    break;
                case TGroup::MANAGER:
                    $users = $tUser->findAllManagersAndBelow();
                    $groups = $tGroup->findAllManagersAndBelow();
                    break;
                default:
                    Dispatcher::route('/home/');
            }

            $engine->assign('users', $users);
            $engine->assign('groups', $groups);
        }

        /**
         *
         */
        public function resetpasswort() {
            $request = $this->getRequest();
            $engine = $this->getView();

            if ($request->post('pw-reset')) {
                if ($this->resetPasswordFunc()) {
                    Dispatcher::route('/anmelden/');
                }
            }
        }

    }
}