<?php

namespace bfw\mvc\controller {

    /**
     * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
     *
     */

    use bfw\Database;
    use bfw\Dispatcher;
    use bfw\mvc\model\Model;
    use bfw\mvc\model\TGroup;
    use bfw\mvc\model\TText;

    class HomeController extends Controller {
        const TEXT_ID = 2;

        /**
         * HomeController constructor.
         *
         * @param Model $model
         * @param Request $request
         */
        public function __construct($model, $request) {
            parent::__construct($model, $request);
        }

        /**
         *
         */
        public function eintragen() {
            $request = $this->getRequest();

            $tText = new TText();
            $text = $tText->find(self::TEXT_ID);

            $text->setHeadline($request->session('headline'));
            $text->setText($request->session('text'));

            if ($tText->store(self::TEXT_ID, $text)) {
                $request->setKey('msg', 'Der CMS-Text wurde aktualisiert.');
            } else {
                $request->setKey('fehler', 'Der CMS-Text kontne nicht aktualisiert werden.');
            }
        }

        /**
         *
         */
        public function reset() {
            $request = $this->getRequest();
            $db = Database::getInstance();

            if (!$db->cleanup()) {
                $request->deleteParameterKey('reset');
                $request->setKey('fehler', 'Fehler beim Aufräumen');
                Dispatcher::route('/');
            }

            $request->deleteParameterKey('reset');
            $request->destroySession();

            Dispatcher::route('/');
        }

        /**
         *
         */
        public function unit() {
            $request = $this->getRequest();

            $db = Database::getInstance();
            $db->csvImport('t_user', 'data/import/test_users.csv');
            $db->csvImport('t_ticket', 'data/import/test_tickets.csv');

            $request->deleteParameterKey('unit');

            Dispatcher::route('/');
        }

        /**
         * Default Index Action
         *
         * Zu berücksichtigen ist hier:
         *
         * Sowohl GET-Actions als auch POST Actions werden berücksichtigt
         */
        public function index() {
            $request = $this->getRequest();
            $engine = $this->getView();

            /**
             * Reset mit Redirect
             */
            if ($request->getParameter('reset') == '1') {
                $this->reset($engine, $request);

                return;
            }

            /**
             * Eintragen mit Redirect
             */
            if ($request->get('unit') == '1') {
                $this->unit();

                return;
            }

            if ($request->post('eintragen') != '') {
                $this->eintragen();
            }

            $tText = new TText();
            $group_id = $request->getKey('group_id', TGroup::GUEST);

            $text = $tText->find(self::TEXT_ID);
            $engine->assign('text', $text);
            $engine->assign('group_id', $group_id);
        }

    }
}