<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\entities;

use bfw\core\Entity;

/**
 * Class TGroup
 *
 * @method string getName()
 * @mthod setName($param)
 */
class TGroup extends Entity {

    const SYSTEM = 1;
    const ADMIN = 2;

    public function __construct() {
        parent::__construct('t_group');

        $this->data = array(
            'id' => NULL,
            'name' => '',
        );
    }

    /**
     * @param $name
     * @return array|null
     */
    public function findByName($name) {
        return $this->db->findByField('t_group', 'name', $name);
    }

}
