<?php

namespace bfw\mvc\common;

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

use bfw\Request;
use bfw\Response;

/**
 *
 */
abstract class Controller {
    /**
     * @var Model
     */
    private $model;

    /**
     * @var Request
     */
    private $request;

    /**
     * @var Response
     */
    private $response;

    /**
     * @var View
     */
    private $view;

    /**
     * @var
     */
    private $prefix;

    /**
     * Controller constructor.
     *
     * @param Model $model
     * @param Request $request
     */
    public function __construct(Model $model) {
        $this->request = new Request();
        $this->response = new Response();

        $this->model = $model;
        $this->view = new View($this, $model);

        $this->prefix = '';
    }

    /**
     * @param $controller
     * @return string
     */
    public static function mapControllerName($controller) {
        return sprintf('bfw\mvc\controller\%sController', ucfirst($controller));
    }

    public function getView() {
        return $this->view;
    }

    public function setView($view) {
        $this->view = $view;

        return $this;
    }

    public function getResponse() {
        return $this->response;
    }

    public function setResponse($response) {
        $this->response = $response;

        return $this;
    }

    /**
     * @return Model
     */
    public function getModel() {
        return $this->model;
    }

    /**
     * @param $model
     * @return $this
     */
    public function setModel($model) {
        $this->model = $model;

        return $this;
    }

    /**
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * @return string
     */
    public function getPage() {
        if ($this->getPrefix() != '') {
            return sprintf('%s/%s', $this->prefix, $this->request->get('action'));
        }

        return $this->request->get('action');
    }

    public function getPrefix() {
        return $this->prefix;
    }

    public function setPrefix($prefix) {
        $this->prefix = $prefix;

        return $this;
    }

    /**
     *
     */
    abstract public function index();
}