<?php

/**
 *
 */

define('TICKET_PATH', dirname(dirname(__FILE__)));

/**
 * Standard-Autoloader für die Basis-Klassen des Projekts
 *
 * @param $class
 * @return bool
 */
function bfw_autoLoader($class) {
    $nsClass = str_replace('\\', '/', $class);
    $filename = sprintf('%s/classes/%s.php', TICKET_PATH, $nsClass);
    $classPath = sprintf('classes/%s.php', $nsClass);

    if (file_exists($filename)) {
        require_once "$classPath";

        return true;
    }

    return false;
}

require_once 'library/log4php/Logger.php';
Logger::configure(TICKET_PATH . '/config/log4php.xml');

spl_autoload_register('bfw_autoLoader');

// Durchs Überschreiben habe ich eine eigene Session und teile mir diese nicht mit den 'PHPSESSID' Leuten...
session_name('bfw-id');
session_start();