<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw;

use bfw\core\Controller;
use bfw\core\View;
use ReflectionClass;
use ReflectionException;

class Dispatcher {
    private $request;

    public function __construct() {
        $this->request = new Request();
    }

    /**
     * @param $url
     */
    public static function route($url) {
        header(sprintf("Location: %s", $url));
        exit(0);
    }

    /**
     * <b>Standard Request Handler für das Projekt</b>
     *
     * Diese Instanz kümmert sich selbständig um die GET- und POST Werte und
     * speichert diese in der Session.
     *
     * Einfach zu nutzende Methoden(Schnittstelle zur Session) komplettieren diesen Handler
     *
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * <b>Führt den jeweiligen Controller aus und liefert ein View zurück</b>
     *
     */
    public function getView() {
        $this->request->keepRequestData();

        $controllerName = $this->request->get('controller', 'home');
        $action = $this->request->get('action', 'index');

        $class = Controller::mapControllerName($controllerName);

        try {
            $reflection = new ReflectionClass($class);
            $controller = $reflection->newInstance();

            // Mapping vom GET-Parameter 'action' auf Controller::$action()
            if (!$reflection->hasMethod($action)) {
                $action = 'index';
            }
        } catch (ReflectionException $e) {
            $controller = new mvc\controller\ErrorController(new TView('NON_EXISTENT'));

            $controllerName = 'error';
            $action = 'index';
        }

        $controller->$action();

        $view = new View($controller, $controller->getModel());
        $view->assign('controller', $controllerName);
        $view->assign('action', $action);

        return $view;
    }

}