<?php

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

namespace bfw\core;

use bfw\Request;
use bfw\Response;
use Logger;

/**
 *
 */
abstract class Controller {
    protected $logger = null;
    /**
     * @var Model
     */
    private $model;
    /**
     * @var Request
     */
    private $request;
    /**
     * @var Response
     */
    private $response;
    /**
     * @var View
     */
    private $view;

    /**
     * Controller constructor.
     *
     * @param Model $model
     * @param Request $request
     */
    public function __construct(Model $model = null) {
        $this->request = new Request();
        $this->response = new Response();

        $this->model = $model;
        $this->view = new View($this, $model);

        $this->logger = Logger::getLogger(__CLASS__);
    }

    /**
     * @param $controller
     * @return string
     */
    public static function mapControllerName($controller) {
        return sprintf('bfw\mvc\controller\%sController', ucfirst($controller));
    }

    public function getView() {
        return $this->view;
    }

    public function setView($view) {
        $this->view = $view;

        return $this;
    }

    public function getResponse() {
        return $this->response;
    }

    public function setResponse($response) {
        $this->response = $response;

        return $this;
    }

    /**
     * @return Model
     */
    public function getModel() {
        return $this->model;
    }

    /**
     * @param $model
     * @return $this
     */
    public function setModel($model) {
        $this->model = $model;

        return $this;
    }

    /**
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     *
     */
    abstract public function index();

    protected function getModelName() {
        $modelName = str_replace('controller', 'model', get_class($this));
        $modelName = strtolower($modelName);

        return str_replace('controller', '\Model', $modelName);
    }
}