<?php

namespace bfw\mvc\model;

use bfw\mvc\common\Model;

/**
 * Class TGroup
 *
 * @method string getName()
 * @mthod setName($param)
 */
class TGroup extends Model {
    const GUEST = 5;
    const SUPPORTER = 4;
    const MANAGER = 3;
    const ADMIN = 2;
    const SYSTEM = 1;

    public function __construct() {
        parent::__construct('t_group');

        $this->data = array(
            'id' => NULL,
            'name' => '',
        );
    }

    /**
     * @param $name
     * @return array|null
     */
    public function findByName($name) {
        return $this->db->findByField('t_group', 'name', $name);
    }

    /**
     * <b>Besorgt ein Array mit der Liste der Manager und Darunter</b>
     *
     * @return array|null
     */
    public function findAllManagersAndBelow() {
        /**
         * SYSTEM = 1
         * ADMIN = 2
         *  [MANAGER = 3, SUPPORTER = 4]
         * GUEST = 5
         */
        $groups = $this->db->fetchAll($this->table, 'id > 2 and id < 5');

        $list = array();
        foreach ($groups as $group) {
            $item = new static();
            $item->data = $group;

            $list[] = $item;
        }

        return $list;
    }
}