<?php

namespace bfw;

/**
 * Copyright(C) 2015 Markus Bröker<broeker.markus@googlemail.com>
 *
 */

use bfw\mvc\common\Controller;
use bfw\mvc\common\View;
use ReflectionClass;

class Dispatcher {
    private $request;

    public function __construct() {
        $this->request = new Request();
    }

    /**
     * @param $url
     */
    public static function route($url) {
        header(sprintf("Location: %s", $url));
        exit(0);
    }

    /**
     * <b>Standard Request Handler für das Projekt</b>
     *
     * Diese Instanz kümmert sich selbständig um die GET- und POST Werte und
     * speichert diese in der Session.
     *
     * Einfach zu nutzende Methoden(Schnittstelle zur Session) komplettieren diesen Handler
     *
     * @return Request
     */
    public function getRequest() {
        return $this->request;
    }

    /**
     * <b>Führt den jeweiligen Controller aus und liefert ein View zurück</b>
     *
     */
    public function getView() {
        $controllerName = $this->request->get('controller');
        $action = $this->request->get('action');

        $this->request->keepRequestData();

        if ($controllerName == '') {
            $controllerName = 'home';
        }

        if ($action == '') {
            $action = 'index';
        }

        try {
            $class = Controller::mapControllerName($controllerName);

            $reflection = new ReflectionClass($class);
            $controller = $reflection->newInstance();

            $prefix = str_replace('bfw\mvc\controller\\', '', strtolower($class));
            $controller->setPrefix(str_replace('controller', '', $prefix));

            // Mapping vom GET-Parameter 'action' auf Controller::$action()
            if ($reflection->hasMethod($action)) {
                $controller->$action();
            } else {
                $controller->index();
            }
        } catch (Exception $e) {
            $controller = new ErrorController(new TView('NON_EXISTENT'), $this->request);
        }

        $view = new View($controller, $controller->getModel());
        $view->assign('action', sprintf('%s/%s', $controller->getPrefix(), $action));

        return $view;
    }

}