<?php

namespace bfw;
/**
 * Response Headers sind kompliziert
 *
 */
class Response {
    private $headers;
    private $statusCode;

    public function __construct() {
        $this->headers = headers_list();
        $this->statusCode = http_response_code();
    }

    public function getHeaders() {
        return $this->headers;
    }

    public function getStatusCode() {
        return $this->statusCode;
    }

    public function setStatusCode($statusCode) {
        $this->statusCode = $statusCode;

        return $this;
    }

    /**
     * @return string
     */
    public function get($key) {
        if (array_key_exists($key, $this->headers)) {
            return $this->headers[$key];
        }

        return '';
    }

}