<?php

namespace bfw\mvc\model;

use bfw\mvc\common\Model;

/**
 * Class THistory
 *
 * @method getTicket_Id()
 * @method getAction_Id()
 * @method getUser_Id()
 * @method getStatus_Id()
 *
 * @method getSubject()
 * @method getMessage()
 *
 * @method getLocked()
 * @method getLast_Access()
 *
 * @method setTicket_Id($param)
 * @method setAction_Id($param)
 * @method setUser_Id($param)
 * @method setStatus_Id($param)
 *
 * @method setSubject($param)
 * @method setMessage($param)
 *
 * @method setLocked($locked)
 * @method setLast_Access($lastAccess)
 *
 */
class THistory extends Model {

    public function __construct() {
        parent::__construct('t_history');

        $this->data = array(
            'id' => NULL,
            'ticked_id' => 1,
            'action_id' => 1,
            'user_id' => 1,
            'status_id' => 1,
            'subject' => '',
            'message' => '',
            'locked' => false,
            'last_access' => 'now()',
        );
    }

    /**
     * <b>Liefert das Name-Attribut der jeweiligen Action</b>
     *
     * @return string
     */
    public function getActionName() {
        $action = new TAction();
        $action->find($this->getAction_Id());

        return $action->getName();
    }

    /**
     * <b>Liefert das Name-Attribut des jeweiligen Status</b>
     *
     * @return string|null
     */
    public function getStatusName() {
        $status = new TStatus();
        $status->find($this->getStatus_Id());

        return $status->getName();
    }

    /**
     * <b>Liefert das jeweilige Username Attribut des angebenen Benutzers</b>
     *
     * @return string
     */
    public function getUsername() {
        $user = new TUser();

        return $user->getFormattedUsername($this->getUser_Id());
    }
}