<?php

/**
 * PersistenceCreator for the BFW Framework
 *
 * @copyright Copyright(C) 2016 4customers
 * @author    Markus Bröker<mbroeker@4customers.de>
 */
define("VERSION", "0.1");
require_once '../config/config.php';

$header = '<?php

/**
 * Entities for The BFW Framework
 *
 * @copyright Copyright(C) 2016 4customers
 * @author    Markus Bröker<mbroeker@4customers.de>
 */

namespace bfw\entities\core;

use bfw\core\Entity;

/**
';

$sql = "SHOW TABLES";
$db = bfw\database\Database::getInstance();

$rows = $db->query($sql);

foreach ($rows as $row) {
    foreach ($row as $name) {
        $fields = $db->query(sprintf("DESCRIBE %s", $name));
        $className = $name;
        $className = preg_replace('/^t_([a-z])/e', 'strtoupper("T$1")', $className);
        $className = preg_replace('/^r_([a-z])/e', 'strtoupper("R$1")', $className);
        $className = preg_replace('/_([a-z])/e', 'strtoupper("$1")', $className);
        $filename = sprintf("%s/classes/bfw/entities/core/%s.php", BFW_PATH, $className);

        $handle = fopen($filename, "w+");
        $content = $header;
        foreach ($fields as $field) {
            if ($field['Field'] != 'id') {
                $methodName = ucfirst($field['Field']);
                $methodName = preg_replace('/_([a-z])/e', 'strtoupper("$1")', $methodName);
                $type = substr($field['Type'], 0, strpos($field['Type'], '('));

                switch ($type) {
                    case 'int':
                    case 'bigint':
                    case 'smallint':
                        $type = "int";
                        break;
                    case 'tinyint':
                        $type = "bool";
                        break;
                    case 'real':
                    case 'float':
                        $type = "float";
                        break;
                    case 'varchar':
                    case 'text':
                    case 'char':
                        $type = "string";
                        break;
                }

                $content .= sprintf(" * @method %s get%s()\n", $type, $methodName);
                $content .= sprintf(" * @method set%s(\$%s)\n", $methodName, $type);
            }
        }
        $content .= "*/\n";

        $content .= sprintf("class %s extends Entity {\n", $className);
        $content .= sprintf("    public function __construct() {\n");
        $content .= sprintf("        parent::__construct('%s');\n", $name);
        $content .= sprintf("    }\n");
        $content .= sprintf("}\n");

        fwrite($handle, $content);
        fclose($handle);
    }
}