/**
 *  $Id: thread.h 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/include/thread.h $
 */

#ifndef __THREAD_H__
#define __THREAD_H__

#include <pthread.h>
#include <sentence.h>
#include <interface.h>
#include <audioplayer.h>

#ifndef TIMEOUT
#define TIMEOUT 186
#endif

typedef struct {
    int satz;
    int items;
    char *fname;
    tts_options ttsopt;
    ttshandles ttsh;
    char **sentences;
    long **timings;
} ThreadData;

/* reads the wavefiles from disk */
void readtext (ThreadData *);

/* stores the data on the harddisk */
void writewav (ThreadData *);

/* (re)starts a thread */
int p_thread_restart (pthread_t, void *, ThreadData *);

#endif
