/**
 *  $Id: sentence.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/src/sentence.c $
 */

#include <sentence.h>

int words (char *ptr)
{
    char *buffer = NULL;
    char *token;
    int count = 0;

    if (ptr != NULL)
        buffer = strdup (ptr);

    if (buffer == NULL)
        return -1;

    token = strtok (buffer, " ");
    while (token != NULL) {
        token = strtok (NULL, " ");
        count++;
    }

    if (buffer != NULL)
        free (buffer);

    return count;
}

int *parse (char *buf)
{
    int count = 0;
    int i;
    int *s_ptr = NULL;

    s_ptr = malloc (2 * sizeof (int));
    s_ptr[count++] = 0;

    for (i = 0; i < strlen (buf); i++)
        switch (buf[i]) {
        case '\n':
        case '\t':
        case '"':
        case '\'':
            buf[i] = ' ';
            break;
        case '.':
        case '!':
        case '?':
            s_ptr = realloc (s_ptr, (count + 2) * sizeof (int));
            if (s_ptr == NULL) {
                printf ("Not enough memory\n");
                return NULL;
            }
            s_ptr[count++] = ++i;
            break;
        default:
            break;
        }

    s_ptr[count] = 0;

    return s_ptr;
}

char *readbuffer (char *fname)
{
    FILE *f;
    char *text = NULL;
    char buffer[201];

    if ((f = fopen (fname, "r")) == NULL) {
        fprintf (stderr, "ERROR: Cannot open %s for reading!\n", fname);
        return NULL;
    }

    text = malloc (2);
    *text = 0;

    while (fgets (buffer, 200, f) != 0) {
        if ((text = realloc (text, strlen (text) + strlen (buffer) + 1)) == NULL) {
            printf ("Not enough memory\n");
            return NULL;
        };
        strcat (text, buffer);
        *buffer = 0;
    }

    fclose (f);
    return text;
}

char *getSentence (char *text, int start, int end)
{
    int i;
    char *value = NULL;

    if ((i = end - start) < 0)
        return NULL;

    value = malloc (i + 1);
    if (value == NULL)
        return NULL;

    i = 1;
    while (i) {
        switch (text[start]) {
        case '.':
        case ',':
        case '!':
        case '?':
        case '(':
        case ')':
        case '\n':
        case ' ':
            start++;
            break;
        default:
            i = 0;
            break;
        }
    }

    for (i = start; i < end; i++) {
        value[i - start] = text[i];
    }

    value[i - start] = 0;

    return value;
}

char **getstrings (char *Text, int *value)
{
    char *ptr;
    int i = 0;
    int count = 0;
    char **sentences = NULL;
    int *s_ptr;

    if ((s_ptr = parse (Text)) == NULL)
        return NULL;

    while (s_ptr[i + 1] > 0) {
        if ((ptr = getSentence (Text, s_ptr[i], s_ptr[i + 1])) == NULL)
            return NULL;
        if (strlen (ptr) > 0) {
            if ((sentences = realloc (sentences, (count + 1) * sizeof (char *) + 1)) == NULL)
                return NULL;
            sentences[count++] = strdup (ptr);
        }
        if (ptr != NULL)
            free (ptr);
        i++;
    }

    if (s_ptr)
        free (s_ptr);

    *value = count;
    return sentences;
}
