/**
 *  $Id: mbrola_interface.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/src/mbrola_interface.c $
 */

#ifdef MBROLA
#include <mbrola_interface.h>

ttshandles interface_init (tts_options t_options)
{
    ttshandles handle;

    return handle;
}

long *interface_get_timing (ttshandles tts, char *text)
{
    long *t = NULL;
    int i = 0;

    for (i = 0; i < strlen (text); i++) {
        t = realloc (t, (i + 2) * sizeof (long));
        t[i] = i * 20 + 10;
    }
#ifdef DEBUG
    printf ("\nTiming analysis ends\n");
#endif

    t[i] = 0;

    return t;
};

int interface_write_to_wav (char *fname, char *text, ttshandles t_handles, tts_options t_options)
{
    char *s = NULL;

    if ((s = malloc (strlen (text) + 80)) == NULL)
        return -1;

    sprintf (s, "printf \"%s\" | bin/mbrola_write_wav - %s", text, fname);
#ifdef DEBUG
    printf ("Writing %s\n", fname);
#endif
    system (s);

    if (s != NULL)
        free (s);
    return 0;
}

tts_options interface_get_cl_opts (int num, char **arguments)
{
    tts_options options = { 0, 0, 0, 0 };
    int c;

    while ((c = getopt (num, arguments, "p:v:i:")) > 0) {
        switch (c) {
        case 'p':
            options.Path = optarg;
            break;
        case 'v':
            options.Voice = optarg;
            break;
        case 'i':
            options.TextFile = optarg;
            break;
        }
    }

    if (options.TextFile == NULL) {
        fprintf (stderr, "It's substantial to give a text file by -i <text file>!\n");
        exit (0);
    }

    return options;
}

#endif
