/**
 *  $Id: keyboard.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/src/keyboard.c $
 */

#include <keyboard.h>

char getSingleKey ()
{
    // read and return single key with 1 second timeout

    struct termios new_settings;
    struct termios stored_settings;
    int timeout = 1;            // 1 sec timeout
    char c;

    tcgetattr (0, &stored_settings);
    new_settings = stored_settings;

    new_settings.c_lflag &= ~(ICANON | ECHO);

    new_settings.c_cc[VTIME] = timeout * 10;
    new_settings.c_cc[VMIN] = 0;
    tcsetattr (0, TCSANOW, &new_settings);

    fflush (stdout);
    c = getchar ();

    tcsetattr (0, TCSANOW, &stored_settings);

#ifdef DEBUG
    if (isalpha (c))
        printf ("received keypress: %c\n", c);
#endif
    return c;
}
