/**
 *  $Id: thread.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/src/thread.c $
 */

#include <thread.h>

int p_thread_restart (pthread_t p_thread, void *func, ThreadData * data)
{
    // stops a thread, waits for it to exit and then restarts it using
    // the current data structure
    int ret;

    pthread_cancel (p_thread);
    if (pthread_join (p_thread, NULL))
        printf ("RESTART: Cannot find a suitable thread :)\n");

    ret = pthread_create (&p_thread, NULL, (void *)func, data);

    /*
     * TODO: Error Handling
     */
    return ret;
}

void readtext (ThreadData * data)
{
    // read the current sentence using the audio player
    // TODO - test for existence (completeness?) of file before read
    char fname[80];

    pthread_setcanceltype (PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
    pthread_cleanup_push (audioplayer_stop, NULL);

    for (; data->satz < data->items; data->satz++) {
        sprintf (fname, "audio/%s-%i.wav", data->fname, data->satz);
        if ((audioplayer (fname, TIMEOUT)) != -1)
            audioplayer_stop ();
        else
            pthread_exit (NULL);
    }

    pthread_exit (NULL);
    pthread_cleanup_pop (1);
}

void writewav (ThreadData * data)
{
    // write wav file for each sentence between data->satz adn
    // data->items
    char fname[80];
    int i;

    for (i = data->satz; i < data->items; i++) {
        sprintf (fname, "audio/%s-%i.wav", data->fname, i);
        interface_write_to_wav (fname, data->sentences[i], data->ttsh, data->ttsopt);
    }

    pthread_exit (NULL);
}
