/**
 *  $Id: main.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/player/main.c $
 */

#include <audioplayer.h>
#include <stdlib.h>
#include <getopt.h>

#define TIMEOUT 186

void help (char *prgname)
{
    printf ("Usage: %s [-h] sndfile1,[sndfile2,...]\n", prgname);
    printf ("\t sndfile\t: a valid wave file\n");
    printf ("\t-h help \t: shows this screen\n");
}

int main (int argc, char **argv)
{
    int i;

    while ((i = getopt (argc, argv, "h")) > 0) {
        switch (i) {
        case 'h':
            help (argv[0]);
            exit (0);
            break;
        default:
            printf ("Unknown Option %c\n", i);
            help (argv[0]);
            exit (0);
        }
    }

    if (argc == optind) {
        help (argv[0]);
        exit (0);
    }

    audio_init ();

    for (i = optind; i < argc; i++) {
        audioplayer (argv[i], TIMEOUT);
        audioplayer_stop ();
    }

    audio_shutdown ();
    return 0;
}
