/**
 *  $Id: audioplayer.h 48 2008-01-09 23:59:19Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/include/audioplayer.h $
 */

#ifndef __AUDIOPLAYER_H__
#define __AUDIOPLAYER_H__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#include <SDL/SDL.h>

/* audioplayer(filename, milliseconds, position) */
int audioplayer (char *, Uint32);

/* initializes the sdl-soundsystem and prepares local structures */
int audio_init ();

/* closes the sdl-soundsystem and frees local structures */
void audio_shutdown ();

/* audioplayer_getwavelength(filename) */
Uint32 audioplayer_getwavelength (char *);

/* returns the bitrate of the wave-file */
int audioplayer_getbitrate ();

/* stopps playback immediately */
void audioplayer_stop ();

/* returns the current time in ms */
Uint32 audioplayer_gettime ();

/* sets the current position in ms */
void audioplayer_settime (long);

/* returns the length of the RIFF in ms */
Uint32 audioplayer_getsoundlen ();

/* returns the current position */
Uint32 audioplayer_getposition ();

/* wait replaces sdl_delay */
void audioplayer_delay (Uint32);

/* switches verbosity on/off */
void audioplayer_setverbose (int);

#endif
