/**
 *  $Id: proser_interface.c 53 2008-01-10 00:19:41Z mbroeker $
 * $URL: http://localhost/svn/c/VirtualReader/trunk/src/proser_interface.c $
 */

#ifdef PROSER
#include <proser_interface.h>

ttshandles interface_init (tts_options propt)
{

    ttshandles pr_handle;

    // initialize Proser options and set default values for a given voice
    if (init_ProserOpt (&propt.ProserOpt, propt.Voice)) {
        fprintf (stderr, "Fatal error occurred in set_ProserOpt: %s\n", GetLastNlpErrorDescription (NULL));
        exit (-1);
    }
    // the path to the TTS input data like dictionaries and prosodic stuff has to be set

    propt.ProserOpt.Path = strdup (propt.Path);

    // here some more manipulations of the standard settings can be done

    propt.ProserOpt.PreEmphasis = propt.PreEmphasis;
    propt.ProserOpt.Speed = propt.Speed;

    // initialize channel //
    if (!(pr_handle.GermanNlp = OpenNlp (&propt.ProserOpt))) {
        fprintf (stderr, "Fatal error occurred in OpenNlp: %s (%d)\n",
                 GetLastNlpErrorDescription (pr_handle.GermanNlp), (int)GetLastNlpError (pr_handle.GermanNlp));
        exit (-1);
    }
    // delete structure for Proser Options //
    if (delete_ProserOpt (&propt.ProserOpt)) {
        fprintf (stderr, "Fatal error occurred in delete_ProserOpt: %s\n", GetLastNlpErrorDescription (NULL));
        exit (-1);
    }
    return pr_handle;
}

int interface_write_to_wav (char *Filename, char *Text, ttshandles prosh, tts_options propt)
{
    // write Text to a file
    if (ProserSynthText (prosh.GermanNlp, Text, Filename, propt.FileType, propt.Stype)) {
        fprintf (stderr, "Fatal error occurred in ProserSynthText: %s\n", GetLastNlpErrorDescription (prosh.GermanNlp));
        return (-1);
    }
    return (0);
}

long *interface_get_timing (ttshandles prosh, char *Text)
{
    // analyze given text, return array with long values containing
    // time in ms when each word of the given text will start in the
    // output
    long *timings = NULL;
    LPPHONEME PhoneticSentenceDescription;
    long NumberOfPhoneticUnits;
    int i = 0, WordNum = 0;

    PhoneticSentenceDescription = TextToPho (prosh.GermanNlp, Text, &NumberOfPhoneticUnits);
#ifdef DEBUG
    printf ("\n[S] %s\n", Text);
#endif
    while (i < (NumberOfPhoneticUnits - 1)) {
        if (PhoneticSentenceDescription[i + 1].Event != 0) {
            timings = realloc (timings, (WordNum + 2) * sizeof (long));
            timings[WordNum] = PhoneticSentenceDescription[i + 1].Offset;
#ifdef DEBUG
            printf ("Wort:\t %i \t Time: %ld ms\n", WordNum, PhoneticSentenceDescription[i + 1].Offset);
#endif
            WordNum++;
        }
        i++;
    }
    timings[WordNum] = 0;
    return timings;
}

tts_options interface_get_cl_opts (int argc, char **argv)
{
    int i, j;
    tts_options propt;

    propt.TextFile = propt.AudioFile = propt.Voice = propt.Path = NULL;

    j = 0;
    propt.PreEmphasis = 0.0f;
    propt.Speed = 1.0f;
    propt.Stype = LIN16;
    propt.FileType = WAV;

    for (i = 1; i < argc; i++) {
        if (!strcmp (argv[i], "-i")) {
            propt.TextFile = argv[++i];
            continue;
        } else if (!strcmp (argv[i], "-o")) {
            propt.AudioFile = argv[++i];
            continue;
        } else if (!strcmp (argv[i], "-v")) {
            propt.Voice = argv[++i];
            continue;
        } else if (!strcmp (argv[i], "-p")) {
            propt.Path = argv[++i];
            continue;
        } else if (!strcmp (argv[i], "-pre")) {
            propt.PreEmphasis = atof (argv[++i]);
            continue;
        } else if (!strcmp (argv[i], "-speed")) {
            propt.Speed = atof (argv[++i]);
            continue;
        } else if (!strcmp (argv[i], "-format")) {
            i++;
            for (j = 0; j < (int)strlen (argv[i]); j++)
                argv[i][j] = toupper (argv[i][j]);
            if (!strcmp (argv[i], "RAW")) {
                propt.FileType = RAW;
                continue;
            } else if (!strcmp (argv[i], "WAV")) {
                propt.FileType = WAV;
                continue;
            } else if (!strcmp (argv[i], "AU")) {
                propt.FileType = AU;
                continue;
            } else {
                fprintf (stderr, "Unknown output type %s\n", argv[i]);
                fprintf (stderr, "Supported output types: RAW - AU - WAV\n");
                exit (-1);
            }
        }
        if (strcmp (argv[i], "-audio") == 0) {
            i++;
            for (j = 0; j < strlen (argv[i]); j++)
                argv[i][j] = toupper (argv[i][j]);
            if (!strcmp (argv[i], "LIN16")) {
                propt.Stype = LIN16;
                continue;
            } else if (!strcmp (argv[i], "LIN8")) {
                propt.Stype = LIN8;
                continue;
            } else if (!strcmp (argv[i], "ULAW")) {
                propt.Stype = ULAW;
                continue;
            } else if (!strcmp (argv[i], "ALAW")) {
                propt.Stype = ALAW;
                continue;
            }
        } else {
            fprintf (stderr, "Unknown option: %s\n", argv[i]);
            exit (-1);
        }
    }

    if (!propt.TextFile) {
        fprintf (stderr, "It's substantial to give a text file by -i <text file>!\n");
        exit (-1);
    } else if (!propt.Voice) {
        fprintf (stderr, "It's substantial to give a voice database by -v <voice>!\n");
        exit (-1);
    } else if (!propt.Path) {
        fprintf (stderr, "It's substantial to give a path for the prosodic stuff by -p <path>!\n");
        exit (-1);
    }
    return (propt);
}
#endif
