package org.homelinux.largo.utils;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;

import javax.swing.ImageIcon;

public class ImgComponent extends Canvas {
    static final long serialVersionUID = 1L;
    private Image img;

    public ImgComponent(String sFile) {
        ClassLoader cl = getClass().getClassLoader();
        URL url = cl.getResource(sFile);
        img = new ImageIcon(url).getImage();
    }

    public Image getImage() {
        return img;
    }

    public Dimension getPreferredSize() {
        return new Dimension(img.getWidth(this), img.getHeight(this));
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }
}
