/**
 *   $Id: MouseListener.java 140 2008-04-25 07:03:13Z mbroeker $
 *  $URL: http://localhost/svn/eclipse/Schachspiel/trunk/org/homelinux/largo/games/board/MouseListener.java $
 */

package org.homelinux.largo.games.board;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MouseListener extends MouseAdapter {
	int width;
	int height;
	int delta;

	Point p;
	boolean selected;

	public MouseListener (int w, int h) {
		width = w;
		height = h;
		p = new Point ();
		selected = false;
	}

	public void mousePressed (MouseEvent e) {
		p.startx = (e.getX () / width);
		p.starty = (e.getY () / height);
		selected = false;
	}

	public void mouseReleased (MouseEvent e) {
		p.endx = (e.getX () / width);
		p.endy = (e.getY () / height);

		print();
		selected = true;
	}

	public boolean isSelected () {
		return selected;
	}

	public Point getSelection () {
		selected = false;
		return p;
	}

	public void print() {
		System.out.printf ("%c%d-%c%d \t",
				(char)('A' + p.startx), 8-p.starty,
				(char)('A' + p.endx), 8-p.endy);
	}
}
