/**
 *   $Id: Checkers.java 144 2008-04-25 13:09:35Z mbroeker $
 *  $URL: http://localhost/svn/eclipse/Schachspiel/trunk/org/homelinux/largo/checkers/Checkers.java $
 */

package org.homelinux.largo.checkers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import org.homelinux.largo.games.board.MouseListener;
import org.homelinux.largo.games.board.Point;
import org.homelinux.largo.utils.BrowserLaunch;

public class Checkers extends JFrame implements Runnable {
	static final long serialVersionUID = 250408;
	static final String helpURL = "http://largo.homelinux.org/cgi-bin/gitweb.cgi?p=games/Schach.git;a=summary";

	MouseListener listener;
	KIBoard board;
	Point p;
	JLabel    human = new JLabel("<html><font size='5' color='#FFFFFF'>Human</font></html>");
	JLabel computer = new JLabel("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
	JButton     neu = new JButton("Play");
	JButton  pconly = new JButton("PC-PC");
	JButton    back = new JButton("Back");
	JButton forward = new JButton("For");
	JButton    help = new JButton("Source");

	SpinnerNumberModel model = new SpinnerNumberModel(4, 1, 8, 1);
	JSpinner combo = new JSpinner(model);

	JPanel panel;
	JPanel fpanel;

	int search_depth;

	boolean pc_only;

	public Checkers (int w, int h) {
		super("Checkers by Largo Enterprises");
		setDefaultCloseOperation (javax.swing.JFrame.EXIT_ON_CLOSE);
		board = new KIBoard(w, h);

		fpanel = new JPanel();
		fpanel.add(back);
		fpanel.add(neu);
		fpanel.add(combo);
		fpanel.add(pconly);
		fpanel.add(help);
		fpanel.add(forward);

		panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(human, "West");
		panel.add(fpanel, "Center");
		panel.add(computer, "East");

		fpanel.setBackground(new Color(50, 100, 200));
		panel.setBackground(new Color(50, 100, 200));

		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(panel, "North");
		getContentPane().add(board, "Center");

		neu.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				human.setText("<html><font size='5' color='#FFFFFF'>Human</font></html>");
				computer.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				pc_only = false;
				board.init();
				board.negateEstimation(false);
			}
		});

		pconly.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				human.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				computer.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				pc_only = true;
			}
		});

		back.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				board.backwards();
			}
		});

		forward.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				board.forward();
			}
		});

		help.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent actionevent) {
				BrowserLaunch browser = new BrowserLaunch();
				browser.openURL(helpURL);
			}
		});

		listener = board.getMouseListener();

		pc_only = false;
		search_depth = 3;
		pack();
	}

	public void computer_play () {
		while (pc_only) {
			search_depth = model.getNumber().intValue()-1;

			if ( !board.isBlacksTurn() ) {
				human.setText("<html><font size='5' color='#FF3333'>Computer</font></html>");
				board.negateEstimation(true);
				if (!board.doBestMove(search_depth) ) {
					pc_only = false;
					return;
				}
				board.negateEstimation(false);
				human.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				board.setBlacksTurn(true);
			} else {
				computer.setText("<html><font size='5' color='#FF3333'>Computer</font></html>");
				if (!board.doBestMove(search_depth) ) {
					pc_only = false;
					return;
				}
				computer.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				board.setBlacksTurn(false);

				if (board.simu_debug()) {
					for (int i=0;i<64;i++) {
						if((i+1)%8 == 0 )
							System.err.printf("%2d=%d%n", i, board.getValue(i));
						else
							System.err.printf("%2d=%d ", i, board.getValue(i));
					}
				}

				try {
					Thread.sleep (10);
				} catch (InterruptedException e) {
					System.err.println("computer_play: " + e.getLocalizedMessage());
					System.err.println("========================================================================");
					e.printStackTrace();
					System.err.println("========================================================================");
					return;
				}
			}
		}
	}

	public void run () {
		for (;;) {

			/* is this thread safe */
			search_depth = model.getNumber().intValue()-1;

			if (pc_only) {
				computer_play ();
			}

			if ( !board.isBlacksTurn() ) {
				if (listener.isSelected ()) {
					p = listener.getSelection ();
					if (board.move (p))
						board.setBlacksTurn(true);
				}
				try {
					Thread.sleep (50);
				}
				catch (InterruptedException e) {
					System.err.println("Schach::run: " + e.getLocalizedMessage());
					System.err.println("========================================================================");
					e.printStackTrace();
					System.err.println("========================================================================");
					return;
				}
			} else {
				human.setText("<html><font size='5' color='#FFFFFF'>Human</font></html>");
				computer.setText("<html><font size='5' color='#FF3333'>Computer</font></html>");
				board.doBestMove(search_depth);
				human.setText("<html><font size='5' color='#FF3333'>Human</font></html>");
				computer.setText("<html><font size='5' color='#FFFFFF'>Computer</font></html>");
				board.setBlacksTurn(false);

				if (board.simu_debug()) {
					for (int i=0;i<64;i++) {
						if((i+1)%8 == 0 )
							System.out.printf("%2d=%d%n", i, board.getValue(i));
						else
							System.out.printf("%2d=%d ", i, board.getValue(i));
					}
				}
			}
		}
	}

	public static void main (String args[]) {
		Checkers c = new Checkers (74, 74);

		c.setResizable(false);
		c.setVisible (true);

		if (args.length == 1 ) {
			if ( args[0].equals("full") )
				c.board.setDebug(true, true);
			else if ( args[0].equals("simu") )
				c.board.setDebug(true, false);
			else if ( args[0].equals("undo") )
				c.board.setDebug(false, true);
			else if ( args[0].equals("none") )
				c.board.setDebug(false, false);
			else {
				System.out.println("   Chess: java -jar games.jar [full|simu|undo|none]");
				System.out.println("Checkers: java -cp games.jar org.homelinux.largo.checkers.Checkers [full|simu|undo|none]");
			}
		}

		Thread t = new Thread(c);
		t.setPriority(Thread.NORM_PRIORITY-1);
		t.start();
	}
}
